// This script runs in the PAGE context (not isolated)
// It can access window.phantom

(function() {
  'use strict';

  // Listen for messages from content script
  window.addEventListener('message', async (event) => {
    if (event.source !== window) return;
    if (!event.data || event.data.source !== 'terminal-chat-content') return;

    const { type, id } = event.data;

    if (type === 'CONNECT_PHANTOM') {
      try {
        const provider = window.phantom?.solana;

        if (!provider?.isPhantom) {
          window.postMessage({
            source: 'terminal-chat-injected',
            id,
            error: 'PHANTOM_NOT_FOUND'
          }, '*');
          return;
        }

        const response = await provider.connect();
        const wallet = response.publicKey.toString();

        window.postMessage({
          source: 'terminal-chat-injected',
          id,
          success: true,
          wallet
        }, '*');

      } catch (err) {
        window.postMessage({
          source: 'terminal-chat-injected',
          id,
          error: err.code === 4001 ? 'USER_REJECTED' : err.message
        }, '*');
      }
    }

    if (type === 'CHECK_PHANTOM') {
      const provider = window.phantom?.solana;
      window.postMessage({
        source: 'terminal-chat-injected',
        id,
        installed: !!provider?.isPhantom
      }, '*');
    }
  });

  // Signal that injected script is ready
  window.postMessage({
    source: 'terminal-chat-injected',
    type: 'READY'
  }, '*');
})();
